/*
 *  SecuDE Release 4.1 (GMD)
 */
/********************************************************************
 * Copyright (C) 1991, GMD. All rights reserved.                    *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/

#include "pem.h"
#ifdef TEST
#include <stdio.h>
#endif


void    aux_free_OctetString(ostr)
OctetString     **ostr;
{
	char	 * proc = "aux_free_OctetString";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (ostr && *ostr) {
		if((*ostr)->octets) free((*ostr)->octets);
		(*ostr)->octets = (char *)0;
		(*ostr)->noctets = 0;
		free(*ostr);
		*ostr = NULLOCTETSTRING;
	}
	return;
}

void    aux_free2_OctetString(ostr)
OctetString     *ostr;
{
	char	 * proc = "aux_free2_OctetString";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (ostr) {
		if(ostr->octets) free(ostr->octets);
		ostr->octets = (char *)0;
		ostr->noctets = 0;
	}
	return;
}


void    aux_free_BitString(bstr)
BitString     **bstr;
{
	char	 * proc = "aux_free_BitString";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (bstr && *bstr) {
		if((*bstr)->bits) free((*bstr)->bits);
		(*bstr)->bits = (char *)0;
		(*bstr)->nbits = 0;
		free(*bstr);
		*bstr = NULLBITSTRING;
	}
	return;
}

void    aux_free2_BitString(bstr)
BitString     *bstr;
{
	char	 * proc = "aux_free2_BitString";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (bstr) {
		if(bstr->bits) free(bstr->bits);
		bstr->bits = (char *)0;
		bstr->nbits = 0;
	}
	return;
}


void    aux_free_ObjId(oid)
ObjId     **oid;
{
	char	 * proc = "aux_free_ObjId";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (oid && *oid) {
		if ((*oid)->oid_elements)
			free((*oid)->oid_elements);
		free(*oid), *oid = NULLOBJID;
	}
	return;
}

void    aux_free2_ObjId(oid)
ObjId     *oid;
{
	char	 * proc = "aux_free2_ObjId";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (oid) {
		if (oid->oid_elements)
			free(oid->oid_elements);
	}
	return;
}


void    aux_free_AlgId(algid)
AlgId   **algid;
{
	OctetString * ostr;
	char	    * proc = "aux_free_AlgId";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (algid && *algid) {
		if ((*algid)->parm) {
			if (aux_ObjId2ParmType((*algid)->objid) == PARM_OctetString) {
				ostr = (OctetString * )(*algid)->parm;
				if(ostr->octets) free(ostr->octets);
			}
			free((*algid)->parm);
		}
		if ((*algid)->objid) aux_free_ObjId(&((*algid)->objid));
		free(*algid);
		*algid = NULLALGID;
	}
	return;
}


void    aux_free2_KeyInfo(p)
register KeyInfo *p;
{
	char	 * proc = "aux_free2_KeyInfo";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (p) {
		if (p->subjectAI)
			aux_free_AlgId(&(p->subjectAI));
		if (p->subjectkey.bits) {
			bzero(p->subjectkey.bits, p->subjectkey.nbits / 8);
			free(p->subjectkey.bits);
		}
	}
	return;
}

void    aux_free2_Signature(p)
register Signature *p;
{
	char	 * proc = "aux_free2_Signature";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (p) {
		if (p->signAI)
			aux_free_AlgId(&(p->signAI));
		if (p->signature.bits) {
			bzero(p->signature.bits, p->signature.nbits / 8);
			free(p->signature.bits);
		}
	}
	return;
}


void    aux_free_KeyInfo(keyinfo)
KeyInfo **keyinfo;
{
	char	 * proc = "aux_free_KeyInfo";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (keyinfo && *keyinfo) {
		aux_free2_KeyInfo(*keyinfo);
		free(*keyinfo);
		*keyinfo = (KeyInfo * ) 0;
	}
	return;
}

void    aux_free_Signature(signature)
Signature **signature;
{
	char	 * proc = "aux_free_Signature";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif
	if (signature && *signature) {
		aux_free2_Signature(*signature);
		free(*signature);
		*signature = (Signature * ) 0;
	}
	return;
}


void    aux_free2_DigestInfo(p)
register DigestInfo *p;
{
	char	 * proc = "aux_free2_DigestInfo";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (p) {
		if (p->digestAI)
			aux_free_AlgId(&(p->digestAI));
		if (p->digest.octets) {
			free(p->digest.octets);
		}
	}
	return;
}


void    aux_free_DigestInfo(digestinfo)
DigestInfo **digestinfo;
{
	char	 * proc = "aux_free_DigestInfo";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (digestinfo && *digestinfo) {
		aux_free2_DigestInfo(*digestinfo);
		free(*digestinfo);
		*digestinfo = (DigestInfo * ) 0;
	}
	return;
}


void    aux_free_SerialNumbers(serialnums)
SerialNumbers ** serialnums;
{
	char	 * proc = "aux_free_SerialNumbers";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (serialnums && * serialnums) {
		free(* serialnums);
		* serialnums = (SerialNumbers * ) 0;
	}
	return;
}


void    aux_free_KeyBits(keybits)
KeyBits **keybits;
{
	register KeyBits * p;
	char	         * proc = "aux_free_KeyBits";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (keybits && (p = *keybits)) {
		if (p->part1.octets) 
			free(p->part1.octets);
		if (p->part2.octets) 
			free(p->part2.octets);
		if (p->part3.octets) 
			free(p->part3.octets);
		if (p->part4.octets) 
			free(p->part4.octets);
		free(p);
		*keybits = (KeyBits * ) 0;
	}
	return;
}


void    aux_free2_KeyBits(p)
register KeyBits *p;
{
	char	 * proc = "aux_free2_KeyBits";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (p) {
		if (p->part1.octets) 
			free(p->part1.octets);
		if (p->part2.octets) 
			free(p->part2.octets);
		if (p->part3.octets) 
			free(p->part3.octets);
		if (p->part4.octets) 
			free(p->part4.octets);
	}
	return;
}


void    aux_free2_PSEToc(p)
register PSEToc *p;
{
	register struct PSE_Objects * o, * o1;
	char	                    * proc = "aux_free2_PSEToc";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (p) {
		if (p->owner) free(p->owner);
		if (p->create) free(p->create);
		if (p->update) free(p->update);
		o = p->obj;
		while (o) {
			o1 = o;
			if (o->name) free(o->name);
			if (o->create) free(o->create);
			if (o->update) free(o->update);
			o = o->next;
			free(o1);
		}
	}
	return;
}

void    aux_free2_PSESel(p)
register PSESel *p;
{
	char	 *proc = "aux_free2_PSESel";
	char     *pp;
	Boolean  is_key_pool();

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (p && is_key_pool(p) == FALSE) {
		if (p->app_name) {
			free(p->app_name);
			p->app_name = CNULL;
		}
		if (p->pin) {

			pp = p->pin;
			while(*pp) *pp++ = '\0';

			free(p->pin);
			p->pin = CNULL;
		}	
		if (p->object.name) {
			free(p->object.name);
			p->object.name = CNULL;
		}
		if (p->object.pin) {

			pp = p->object.pin;
			while(*pp) *pp++ = '\0';

			free(p->object.pin);
			p->object.pin = CNULL;
		}
	}
	return;
}


void    aux_free_PSEToc(psetoc)
PSEToc **psetoc;
{
	char	 * proc = "aux_free_PSEToc";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (psetoc && *psetoc) {
		aux_free2_PSEToc(*psetoc);
		free(*psetoc);
		*psetoc = (PSEToc * ) 0;
	}
	return;
}

void    aux_free_PSESel(psesel)
PSESel **psesel;
{
	char	 * proc = "aux_free_PSESel";
	Boolean is_key_pool();

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (psesel && *psesel && is_key_pool(*psesel) == FALSE) {
		aux_free2_PSESel(*psesel);
		if(*psesel) free(*psesel);
		*psesel = (PSESel * ) 0;
	}
	return;
}


void    aux_free2_AlgId(algid)
register AlgId *algid;
{
	char	 * proc = "aux_free2_AlgId";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (algid) {
		if (algid->objid)
			aux_free_ObjId(&(algid->objid));
		if (algid->parm)
			free(algid->parm);
	}
	return;
}


void	RDName_comp_free (rdn)
RDName *rdn;
{
	char	 * proc = "RDName_comp_free";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	aux_free_ObjId((ObjId **) & ((rdn->member_IF_0->element_IF_0)) );
	pe_free(rdn->member_IF_0->element_IF_1);
	free ((char *) rdn);
}


void	aux_free2_RDName (rdn)
RDName *rdn;
{
	register RDName * eptr;
	register RDName * next;
	char	        * proc = "aux_free2_RDName";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	for (eptr = rdn; eptr != NULLRDNAME; eptr = next) {
		next = eptr->next;
		RDName_comp_free (eptr);
	}
}


void    aux_free_RDName(rdn)
RDName ** rdn;
{
	char	 * proc = "aux_free_RDName";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (rdn && * rdn) aux_free2_RDName(* rdn);
	return;
}


void	DName_comp_free (dn)
DName * dn;
{
	char	 * proc = "DName_comp_free";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	aux_free2_RDName (dn->element_IF_2);
}


void	aux_free2_DName (dn)
register DName * dn;
{
	register DName * eptr;
	register DName * next;
	char	       * proc = "aux_free2_DName";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	for (eptr = dn; eptr != NULLDNAME; eptr = next) {
		next = eptr->next;
		DName_comp_free (eptr);
		free ((char *) eptr);
		eptr = NULLDNAME;
	}
	return;
}


void    aux_free_DName(dn)
DName **dn;
{
	char	 * proc = "aux_free_DName";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (dn && *dn) aux_free2_DName(*dn);
	return;
}


void    aux_free2_ToBeSigned(tbs)
register ToBeSigned *tbs;
{
	char	 * proc = "aux_free2_ToBeSigned";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (tbs) {
		aux_free_AlgId( &(tbs->signatureAI) );
		if (tbs->issuer) 
			aux_free_DName(&(tbs->issuer));
		if (tbs->notbefore) 
			free (tbs->notbefore);
		if (tbs->notafter) 
			free (tbs->notafter);
		if (tbs->subject) 
			aux_free_DName(&(tbs->subject));
		aux_free_KeyInfo( &(tbs->subjectPK) );
	}
	return;
}


void    aux_free_ToBeSigned(tbs)
ToBeSigned **tbs;
{
	char	 * proc = "aux_free_ToBeSigned";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (tbs && *tbs) {
		aux_free2_ToBeSigned(*tbs);
		free(*tbs);
		*tbs = (ToBeSigned * ) 0;
	}
	return;
}


void    aux_free2_Certificate(cert)
register Certificate *cert;
{
	char	 * proc = "aux_free2_Certificate";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (cert) {
		if (cert->tbs_DERcode) 
			aux_free_OctetString(&(cert->tbs_DERcode));
		aux_free_ToBeSigned(&(cert->tbs));
		aux_free_KeyInfo((KeyInfo **) & ((cert->sig)));
	}
	return;
}


void    aux_free_Certificate(cert)
Certificate **cert;
{
	char	 * proc = "aux_free_Certificate";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (cert && *cert) {
		aux_free2_Certificate(*cert);
		free(*cert);
		*cert = (Certificate * ) 0;
	}
	return;
}

void    aux_free_RecpList(recp)
RecpList **recp;
{
	char	 * proc = "aux_free_RecpList";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (recp && *recp) {
		aux_free_Certificate(&(*recp)->recpcert);
		aux_free_OctetString(&(*recp)->key);
		aux_free_RecpList(&(*recp)->next);
		free(*recp);
		*recp = (RecpList * ) 0;
	}
	return;
}

void    aux_free2_Key(key)
register Key *key;
{
	char	 * proc = "aux_free2_Key";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (key) {
		aux_free_KeyInfo(&(key->key));
		aux_free_PSESel(&(key->pse_sel));
		aux_free_AlgId(&(key->alg));
	}
	return;
}


void    aux_free2_PemInfo(info)
register PemInfo *info;
{
	char	 * proc = "aux_free2_PemInfo";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (info) {
		aux_free_Key(&(info->encryptKEY));
		aux_free_Certificates( &(info->origcert) );
		aux_free_AlgId( &(info->signAI) );
		aux_free_RecpList( &(info->recplist) );
	}
	return;
}


void    aux_free_PemInfo(info)
PemInfo **info;
{
	char	 * proc = "aux_free_PemInfo";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (info && *info) {
		aux_free2_PemInfo(*info);
		free(*info);
		*info = (PemInfo * ) 0;
	}
	return;
}


void    aux_free_Key(key)
Key **key;
{
	char	 * proc = "aux_free_Key";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (key && *key) {
		aux_free2_Key(*key);
		free(*key);
		*key = (Key * ) 0;
	}
	return;
}


void    aux_free_CertificateSet(certset)
SET_OF_Certificate **certset;
{
	SET_OF_Certificate * save_certset;
	char	           * proc = "aux_free_CertificateSet";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (certset && *certset) {
		while (*certset) {
			save_certset = *certset;
			*certset = save_certset->next;

			aux_free_Certificate(&save_certset->element);

			free(save_certset);
		}
	}
	return;
}


void    aux_free2_CertificatePair(cpair)
register CertificatePair *cpair;
{
	char	 * proc = "aux_free2_CertificatePair";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (cpair) {
		if (cpair->forward) 
			aux_free_Certificate(&cpair->forward);
		if (cpair->reverse) 
			aux_free_Certificate(&cpair->reverse);
	}
	return;
}


void    aux_free_CertificatePair(cpair)
CertificatePair **cpair;
{
	char	 * proc = "aux_free_CertificatePair";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (cpair && *cpair) {
		aux_free2_CertificatePair(*cpair);
		free(*cpair);
		*cpair = (CertificatePair * ) 0;
	}
	return;
}


void    aux_free_CertificatePairSet(cpairset)
SET_OF_CertificatePair **cpairset;
{
	SET_OF_CertificatePair * savecpairset;
	char		       * proc = "aux_free_CertificatePairSet";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (cpairset) {
		while (*cpairset) {
			savecpairset = *cpairset;
			*cpairset = savecpairset->next;

			aux_free_CertificatePair(&savecpairset->element);

			free(savecpairset);
		}
	}
	return;
}


void    aux_free_CrossCertificates(ccerts)
CrossCertificates **ccerts;
{
	char	 * proc = "aux_free_CrossCertificates";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (ccerts && *ccerts) {
		aux_free2_CrossCertificates(*ccerts);
		free(*ccerts);
		*ccerts = (CrossCertificates * ) 0;
	}
	return;
}


void    aux_free2_CrossCertificates(ccerts)
register CrossCertificates *ccerts;
{
	register CrossCertificates * c, * c1;
	char			   * proc = "aux_free2_CrossCertificates";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (ccerts) {
		aux_free_Certificate( &(ccerts->element) );
		c = ccerts->next;
		while (c) {
			c1 = c;
			aux_free_Certificate( &(c->element) );
			c = c->next;
			free(c1);
		}
	}
	return;
}


void    aux_free_FCPath(path)
FCPath **path;
{
	register FCPath * p, * p1;
	char	        * proc = "aux_free_FCPath";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (path && *path) {
		aux_free_CrossCertificates( &((*path)->liste) );
		p = (*path)->next_forwardpath;
		while (p) {
			p1 = p;
			aux_free_CrossCertificates( &(p->liste) );
			p = p->next_forwardpath;
			free(p1);
		}
		free(*path);
		*path = (FCPath * ) 0;
	}
	return;
}


void    aux_free_Certificates(certs)
Certificates **certs;
{
	char	 * proc = "aux_free_Certificates";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (certs && *certs) {
		if ( (*certs)->usercertificate )
			aux_free_Certificate( &((*certs)->usercertificate) );
		if ( (*certs)->forwardpath )
			aux_free_FCPath( &((*certs)->forwardpath) );
		free(*certs);
		*certs = (Certificates * ) 0;
	}
	return;
}


void    aux_free_PemCrlWithCerts(pemcrlwithcerts)
PemCrlWithCerts ** pemcrlwithcerts;
{
	char	 * proc = "aux_free_PemCrlWithCerts";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (pemcrlwithcerts && * pemcrlwithcerts) {
		if ( (* pemcrlwithcerts)->pemcrl )
			aux_free_PemCrl( &((* pemcrlwithcerts)->pemcrl) );
		if ( (* pemcrlwithcerts)->certificates )
			aux_free_Certificates( &((* pemcrlwithcerts)->certificates) );

		free(* pemcrlwithcerts);
		* pemcrlwithcerts = (PemCrlWithCerts * ) 0;
	}
	return;
}


void    aux_free_SET_OF_PemCrlWithCerts(set)
SET_OF_PemCrlWithCerts ** set;
{
	SET_OF_PemCrlWithCerts * save_set;
	char	               * proc = "aux_free_SET_OF_PemCrlWithCerts";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (set && *set) {
		while (* set) {
			save_set = * set;
			* set = save_set->next;
			aux_free_PemCrlWithCerts(&save_set->element);
			free(save_set);
		}
	}
	return;
}


void    aux_free_CertificationPath(certpath)
CertificationPath ** certpath;
{
	char	 * proc = "aux_free_CertificationPath";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if(certpath && * certpath) {
		if((* certpath)->userCertificate)
			aux_free_Certificate(&((*certpath)->userCertificate));
		if((* certpath)->theCACertificates)
			aux_free_CertificatePairs(&((* certpath)->theCACertificates));

		free(* certpath);
		* certpath = (CertificationPath * ) 0;
	}
	return;
}


void    aux_free_CertificatePairs(pairs)
CertificatePairs ** pairs;
{
	char * proc = "aux_free_CertificatePairs";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (pairs && * pairs) {
		aux_free_SEQUENCE_OF_CertificatePair(&((* pairs)->liste));
		aux_free_CertificatePairs(&((* pairs)->superior));
	
		free(* pairs);
		* pairs = (CertificatePairs * ) 0;	
	}
	return;
}


void    aux_free_SEQUENCE_OF_CertificatePair(seq)
SEQUENCE_OF_CertificatePair ** seq;
{
	register SEQUENCE_OF_CertificatePair * eptr;
	register SEQUENCE_OF_CertificatePair * next;

	char * proc = "aux_free_SEQUENCE_OF_CertificatePair";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if(seq && * seq){
		for(eptr = * seq; eptr != (SEQUENCE_OF_CertificatePair * )0; eptr = next){
			next = eptr->next;
			aux_free_CertificatePair(&(eptr->element));
			free((char * )eptr);
			eptr = (SEQUENCE_OF_CertificatePair * )0;
		}
	}
	return;
}


void    aux_free_PKRoot(pkroot)
register PKRoot **pkroot;
{
	char	 * proc = "aux_free_PKRoot";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (pkroot && *pkroot) {

		if ((*pkroot)->ca)
			aux_free_DName(&((*pkroot)->ca));

		if ((*pkroot)->newkey)
			aux_free_RootInfo(&((*pkroot)->newkey));

		if ((*pkroot)->oldkey)
			aux_free_RootInfo(&((*pkroot)->oldkey));

		free(* pkroot);
		* pkroot = (PKRoot * ) 0;
	}
	return;
}


void    aux_free_RootInfo(rootinfo)
register Serial **rootinfo;
{
	char	 * proc = "aux_free_RootInfo";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (rootinfo && *rootinfo) {

		if ((*rootinfo)->key)
			aux_free_KeyInfo(&((*rootinfo)->key));

		if ((*rootinfo)->notbefore) {
			free((*rootinfo)->notbefore);
			(*rootinfo)->notbefore = (UTCTime * )0;
		}

		if ((*rootinfo)->notafter) {
			free((*rootinfo)->notafter);
			(*rootinfo)->notafter = (UTCTime * )0;
		}

		if ((*rootinfo)->sig)
			aux_free_KeyInfo((KeyInfo **) &((*rootinfo)->sig));

		free(* rootinfo);
		* rootinfo = (Serial * ) 0;
	}

	return;
}


void    aux_free_PKList(pklist)
PKList **pklist;
{
	register PKList * pkl;
	char	        * proc = "aux_free_PKList";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if(pklist && *pklist) {
		while (*pklist) {
			pkl = *pklist;
			aux_free2_ToBeSigned(pkl->element);
			*pklist = pkl->next;
			free(pkl);
		}
	}
	return;
}


void aux_free_error()
{
	register struct ErrStack * err;
	char		         * proc = "aux_free_error";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	while (err_stack) {
		err = err_stack;
		if(err->e_addr) switch (err->e_addrtype) {

			case    char_n:
					free(err->e_addr);
					break;
			case 	Certificate_n:
					aux_free_Certificate(&err->e_addr);
					break;
			case 	CertificatePair_n:
					aux_free_CertificatePair(&err->e_addr);
					break;
			case 	Certificates_n:
					aux_free_Certificates(&err->e_addr);
					break;
			case 	PKList_n:
					aux_free_PKList(&err->e_addr);
					break;
			case 	OctetString_n:
					aux_free_OctetString(&err->e_addr);
					break;
			case 	BitString_n:
					aux_free_BitString(&err->e_addr);
					break;
			case 	SET_OF_Certificate_n:
					aux_free_CertificateSet(&err->e_addr);
					break;
			case 	SET_OF_CertificatePair_n:
					aux_free_CertificatePairSet(&err->e_addr);
					break;
			case 	OCList_n:
					aux_free_OCList(&err->e_addr);
					break;
			case 	AlgId_n:
					aux_free_AlgId(&err->e_addr);
					break;
			case    CrlTBS_n:
					aux_free_CrlTBS(&err->e_addr);
					break;
			case    Crl_n:
					aux_free_Crl(&err->e_addr);
					break;
			case    RevCert_n:
					aux_free_RevCert(&err->e_addr);
					break;
			case    PemInfo_n:
					aux_free_PemInfo(&err->e_addr);
					break;
			case    KeyInfo_n:
					aux_free_KeyInfo(&err->e_addr);
					break;
			case 	FCPath_n:
					aux_free_FCPath(&err->e_addr);
					break;
  			case 	PKRoot_n:
					aux_free_PKRoot(&err->e_addr);
					break;
			case 	ToBeSigned_n:
					aux_free_ToBeSigned(&err->e_addr);
					break;
			case 	ObjId_n:
					aux_free_ObjId(&err->e_addr);
					break;
			case 	KeyBits_n:
					aux_free_KeyBits(&err->e_addr);
					break;
			case 	PSEToc_n:
					aux_free_PSEToc(&err->e_addr);
					break;
			case 	PSESel_n:
					aux_free_PSESel(&err->e_addr);
					break;
		}

		err_stack = err->next;
		free(err);
	}
	err_malloc.e_number = 0;
	err_malloc.e_text = CNULL;
	err_malloc.e_addr = CNULL;
	err_malloc.e_proc = CNULL;
	err_malloc.next = (struct ErrStack * ) 0;
	return;
}


void    aux_free2_CrlPSE(crlpse)
register CrlPSE *crlpse;
{
	char	   * proc = "aux_free2_CrlPSE";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (crlpse) {
		if (crlpse->issuer) 
			aux_free_DName(&(crlpse->issuer));
		if (crlpse->nextUpdate) 
			free (crlpse->nextUpdate);
		if(crlpse->revcerts)
			aux_free_SEQUENCE_OF_RevCertPem(&(crlpse->revcerts));
	}
	return;
}


void    aux_free_CrlPSE(crlpse)
CrlPSE **crlpse;
{
	char	 * proc = "aux_free_CrlPSE";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (crlpse && *crlpse) {
		aux_free2_CrlPSE(*crlpse);
		free(*crlpse);
		*crlpse = (CrlPSE * ) 0;
	}
	return;
}


void    aux_free_CrlSet(crlset)
CrlSet **crlset;
{
	CrlSet * save_crlset;
	char	   * proc = "aux_free_CrlSet";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (crlset) {
		while (*crlset) {
			save_crlset = *crlset;
			*crlset = save_crlset->next;

			aux_free_CrlPSE(&save_crlset->element);

			free(save_crlset);
		}
	}
	return;
}


void aux_free2_RevCertTBS(tbs)
register RevCertTBS *tbs;
{
	char	 * proc = "aux_free2_RevCertTBS";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (tbs) {
		if(tbs->signatureAI)
			aux_free_AlgId(&(tbs->signatureAI));
		if (tbs->issuer)
			aux_free_DName(&(tbs->issuer));
		if (tbs->revocationdate)
			free(tbs->revocationdate);
	}
	return;
}


void aux_free_RevCertTBS(tbs)
RevCertTBS **tbs;
{
	char	 * proc = "aux_free_RevCertTBS";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (tbs && *tbs) {
		aux_free2_RevCertTBS(*tbs);
		free(*tbs);
		*tbs = (RevCertTBS * ) 0;
	}
	return;
}


void aux_free2_RevCert(revcert)
register RevCert *revcert;
{
	char	 * proc = "aux_free2_RevCert";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (revcert) {
		/*if (revcert->tbs_DERcode) 
		    aux_free_OctetString( &(revcert->tbs_DERcode) );*/
		aux_free_RevCertTBS( &(revcert->tbs) );
		aux_free_KeyInfo((KeyInfo **) & ((revcert->sig)) );
	}
	return;
}


void aux_free_RevCert(revcert)
RevCert **revcert;
{
	char	 * proc = "aux_free_RevCert";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (revcert && *revcert) {
		aux_free2_RevCert(*revcert);
		free(*revcert);
		*revcert = (RevCert * ) 0;
	}
	return;
}


void aux_free_SEQUENCE_OF_RevCert(seq)
SEQUENCE_OF_RevCert **seq;
{
	SEQUENCE_OF_RevCert * save_seq;
	char		    * proc = "aux_free_SEQUENCE_OF_RevCert";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (seq) {
		while (*seq) {
			save_seq = *seq;
			*seq = save_seq->next;

			aux_free_RevCert( &save_seq->element );

			free(save_seq);
		}
	}
	return;
}


void aux_free2_CrlTBS(tbs)
register CrlTBS *tbs;
{
	char	 * proc = "aux_free2_CrlTBS";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (tbs) {
		if(tbs->signatureAI)
			aux_free_AlgId(&(tbs->signatureAI));
		if (tbs->issuer)
			aux_free_DName(&(tbs->issuer));
		if (tbs->lastupdate)
			free(tbs->lastupdate);
		aux_free_SEQUENCE_OF_RevCert( &(tbs->revokedcertificates) );
	}
	return;
}


void aux_free_CrlTBS(tbs)
CrlTBS **tbs;
{
	char	 * proc = "aux_free_CrlTBS";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (tbs && *tbs) {
		aux_free2_CrlTBS(*tbs);
		free(*tbs);
		*tbs = (CrlTBS * ) 0;
	}
	return;
}


void aux_free2_Crl(crl)
register Crl *crl;
{
	char	 * proc = "aux_free2_Crl";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (crl) {
		/*if (crl->tbs_DERcode)
		    aux_free_OctetString( &(crl->tbs_DERcode) );*/
		aux_free_CrlTBS( &(crl->tbs) );
		aux_free_KeyInfo((KeyInfo **) & ((crl->sig)) );
	}
	return;
}


void aux_free_Crl(crl)
Crl **crl;
{
	char	 * proc = "aux_free_Crl";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	/*
	if (crl && *crl) {
		aux_free2_Crl(*crl);
		free(*crl);
		*crl = (Crl * ) 0;
	}
	return;
*/
}


void aux_free2_RevCertPem(revcertpem)
register RevCertPem *revcertpem;
{
	char	 * proc = "aux_free2_RevCertPem";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (revcertpem) {
		if (revcertpem->revocationDate)
			free(revcertpem->revocationDate);
	}
	return;
}


void aux_free_RevCertPem(revcertpem)
RevCertPem **revcertpem;
{
	char	 * proc = "aux_free_RevCertPem";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (revcertpem && *revcertpem) {
		aux_free2_RevCertPem(*revcertpem);
		free(*revcertpem);
		*revcertpem = (RevCertPem * ) 0;
	}
	return;
}


void aux_free_SEQUENCE_OF_RevCertPem(seq)
SEQUENCE_OF_RevCertPem **seq;
{
	SEQUENCE_OF_RevCertPem  * save_seq;
	char	 		* proc = "aux_free_SEQUENCE_OF_RevCertPem";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (seq) {
		while (*seq) {
			save_seq = *seq;
			*seq = save_seq->next;

			aux_free_RevCertPem( &save_seq->element );

			free(save_seq);
		}
	}
	return;
}


void aux_free2_PemCrlTBS(tbs)
register PemCrlTBS *tbs;
{
	char	 * proc = "aux_free2_PemCrlTBS";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (tbs) {
		if(tbs->signatureAI)
			aux_free_AlgId(&(tbs->signatureAI));
		if (tbs->issuer)
			aux_free_DName(&(tbs->issuer));
		if (tbs->lastUpdate)
			free(tbs->lastUpdate);
		if (tbs->nextUpdate)
			free(tbs->nextUpdate);
		if (tbs->revokedCertificates)
			aux_free_SEQUENCE_OF_RevCertPem( &(tbs->revokedCertificates) );
	}
	return;
}


void aux_free_PemCrlTBS(tbs)
PemCrlTBS **tbs;
{
	char	 * proc = "aux_free_PemCrlTBS";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (tbs && *tbs) {
		aux_free2_PemCrlTBS(*tbs);
		free(*tbs);
		*tbs = (PemCrlTBS * ) 0;
	}
	return;
}


void aux_free2_PemCrl(pemcrl)
register PemCrl *pemcrl;
{
	char	 * proc = "aux_free2_PemCrl";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (pemcrl) {
		/*if (pemcrl->tbs_DERcode)
		    aux_free_OctetString( &(pemcrl->tbs_DERcode) );*/
		aux_free_PemCrlTBS( &(pemcrl->tbs) );
		aux_free_KeyInfo((KeyInfo **) & ((pemcrl->sig)) );
	}
	return;
}


void aux_free_PemCrl(pemcrl)
PemCrl **pemcrl;
{
	char	 * proc = "aux_free_PemCrl";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	/*
	if (pemcrl && *pemcrl) {
		aux_free2_PemCrl(*pemcrl);
		free(*pemcrl);
		*pemcrl = (PemCrl * ) 0;
	}
	return;
*/
}


void aux_free_OCList(ocl)
OCList **ocl;
{
	char	 * proc = "aux_free_OCList";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	/*
	OCList *saveocl;

	if (ocl) {
		while (*ocl) {
			saveocl = *ocl;
			*ocl = saveocl->next;

			aux_free_Certificate( &saveocl->ccert );

			free(saveocl);
			}
	}
	return;
*/
}

void    aux_free_IssuedCertificate(isscert)
IssuedCertificate **isscert;
{
	if (isscert && *isscert) {
		if ((*isscert)->date_of_issue)
			free ((*isscert)->date_of_issue);
		free (*isscert);
		*isscert = (IssuedCertificate * ) 0;
	}
	return;
}


void    aux_free_SET_OF_IssuedCertificate(isscertset)
SET_OF_IssuedCertificate **isscertset;
{
	SET_OF_IssuedCertificate * save_isscertset;
	if (isscertset) {
		while (*isscertset) {
			save_isscertset = *isscertset;
			*isscertset = save_isscertset->next;

			aux_free_IssuedCertificate(&save_isscertset->element);

			free(save_isscertset);
		}
	}
	return;
}



void    aux_free_VerificationStep(verstep)
VerificationStep **verstep;
{
	char	 * proc = "aux_free_VerificationStep";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (verstep && * verstep) {
		if ( (* verstep)->cert )
			aux_free_Certificate(&((* verstep)->cert));
		if ( (* verstep)->date )
			free((* verstep)->date);
		free(* verstep);
		* verstep = (VerificationStep * ) 0;
	}
	return;
}



void    aux_free_VerificationResult(result)
VerificationResult **result;
{
	int	index = 0;
	char  * proc = "aux_free_VerificationResult";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (result && * result) {
		if ((* result)->verifstep) {
			while (((* result)->verifstep)[index]) {	
				aux_free_VerificationStep(&(((* result)->verifstep)[index]));
				index++;
			} /* while */
		} /* if */
		if((* result)->top_name) 
			free((* result)->top_name);
		if((* result)->date) { 
			free ((* result)->date);
			(* result)->date = (UTCTime * )0;
		}

		free(* result);
		* result = (VerificationResult * ) 0;
	}
	return;
}
